"""
HB_LoopSelection V1.2

Last Modified: Oct/11/2018
Works with CINEMA 4D R16.050 and up.
Copyright: Holger Biebrach, www.c4dstuff.com

Name-US: HB_LoopSelection
Description-US: Activates Edge mode and Loop Selection Tool [SHIFT: Poly mode , CTRL: Boundary Loop ]

Activates Edge- mode and sets up the Loop Selection Tool. SHIFT will change to Polymode instead. CTRL will enable Boundary Loop

Video Tutorial:
https://youtu.be/Ki6I9sRdeUU?t=5m18s

ChangeLog:

Jun/11/2015 V1.0
-Release Version

Nov/1/2015 V1.1
- Edgemode instead of Polymode

Oct/11/2018 V1.2
- New Highres Icon
- CTRL for Boundry Selection
- SHIFT to enable Polymode

"""

import c4d
from c4d import documents, plugins


def tool():
    return plugins.FindPlugin(doc.GetAction(), c4d.PLUGINTYPE_TOOL)
    
def main():
    
    bc = c4d.BaseContainer()
    if c4d.gui.GetInputState(c4d.BFM_INPUT_KEYBOARD,c4d.BFM_INPUT_CHANNEL,bc):

            
        if bc[c4d.BFM_INPUT_QUALIFIER] ==0 or bc[c4d.BFM_INPUT_QUALIFIER] ==4: 
            c4d.CallCommand(16351) # Edges
            c4d.CallCommand(1011192) # Loop Selection
            tool()[c4d.MDATA_LOOP_SEL_SELECT_BOUNDS]=False
            tool()[c4d.MDATA_LOOP_SEL_STOP_AT_BOUNDS]=True
          
        if bc[c4d.BFM_INPUT_QUALIFIER] ==1: # SHIFT
            
            c4d.CallCommand(12187) # Polygons
            c4d.CallCommand(1011192) # Loop Selection
            tool()[c4d.MDATA_LOOP_SEL_SELECT_BOUNDS]=False
            tool()[c4d.MDATA_LOOP_SEL_STOP_AT_BOUNDS]=True
            
        if bc[c4d.BFM_INPUT_QUALIFIER] ==2: # CTRL
            c4d.CallCommand(16351) # Edges
            
            c4d.CallCommand(1011192) # Loop Selection
            tool()[c4d.MDATA_LOOP_SEL_SELECT_BOUNDS]=True
    
if __name__=='__main__':
    main()
    c4d.EventAdd()